#ifndef DRAWERDLG_H
#define DRAWERDLG_H

#include <QDialog>
#include <QGraphicsView>
#include <QtGui>
#include "mode1/erdiagram/Table.h"
#include "tableRelationDlg.h"
#include "tableProperty.h"

class Canvas;
class QAction;
class QMenu;
class QMenuBar;
class QToolBar;
class QToolButton;
class QPushButton;
class QButtonGroup;
class QFont;
class QToolButton;
class QAbstractButton;
class QGraphicsView;
class DrawERDlg;
class RelationInfo;

class DrawERDlg : public QDialog
{
    Q_OBJECT
		
	public:
		DrawERDlg(QWidget *parent = 0);
		virtual ~DrawERDlg();
		
	public slots:
		void ItemInserted(Table* table);
		void ItemInserted(Arrow* arrow);
		
		void PointerGroupClicked(int id);
		void clickBack();
		void clickApply();
		void clickCancel();
		
	public:
		QGraphicsView* GraphicView() const;
		Canvas* GetCanvas() const;
		
		// 
		QList<tableProperty*>& GetTables();
		QList<RelationInfo*>& GetRelationInfo();
		int relaitonCardiMode;
		
		
	public:
		void createActions();		//Action
		void createMenus();			//Menus .
		void createToolbars();		//Toolbar .
		
		QMenu *createColorMenu(const char *slot, QColor defaultColor);		//ColorMenu .(ٲٴ κ)
		QIcon createColorToolButtonIcon(const QString &image, QColor color);
		QIcon createColorIcon(QColor color);
		int a;
		// 
	public:
	/*
	̱  ...
		*/
		static DrawERDlg* getInstance()
		{
			if (uniqueInstance == 0){
				qDebug() << "uniqueInstance";
				uniqueInstance = new DrawERDlg();
			}
			return uniqueInstance;
		}
		
		//
		
	private:
		QGraphicsView	*erView;		//GraphicsView κ
		Canvas			*canvas;		//DigramScene κ
		
		QAction		*exitAct;
		QAction		*deleteAct;
		QAction*	aboutAct;
		QAction*	saveAct;
		QAction*	openAct;
		
		QMenuBar	*erMenuBar;			
		QMenu		*fileMenu;
		QMenu		*itemMenu;
		QMenu		*aboutMenu;
		
		QToolBar		*erToolbar;					//E-R Diagram  κ
		QToolBar		*erRelationToolbar;
		
		QToolButton		*pointerToolButton;			//  κ
		QToolButton		*tableToolButton;			//table Է κ
		QToolButton		*lineToolButton1;			//table ἱ1 κ
		QToolButton		*lineToolButton2;			//table ἱ1 κ
		QToolButton		*lineToolButton3;			//table ἱ1 κ

		QToolButton		*zeroButton;			//table ἱ1 κ
		QToolButton		*oneButton;			//table ἱ1 κ
		QToolButton		*manyButton;			//table ἱ1 κ
		
		//QToolButton		*textToolButton;			//text Է κ
		QButtonGroup	*erTypeGroup;				//erToolButton  ButtonGroup
		QButtonGroup	*erRelationGroup;				//erToolButton  ButtonGroup
		
		QPushButton		*backBtn;					//BackBtn
		QPushButton		*applyBtn;					//ApplyBtn
		QPushButton		*cancelBtn;					//CancelBtn
		
		// 
		QList<tableProperty*> tables;
		QList<RelationInfo*> relationInfo;
		
		// 
		static DrawERDlg* uniqueInstance;
};

inline QGraphicsView* DrawERDlg::GraphicView() const
{
	return this->erView;
}

inline Canvas* DrawERDlg::GetCanvas() const
{
	return this->canvas;
}

// 
inline QList<tableProperty*>& DrawERDlg::GetTables()
{
	return this->tables;
}

inline QList<RelationInfo*>& DrawERDlg::GetRelationInfo()
{
	return this->relationInfo;
}

#endif //DRAWERDLG_H
